#pragma once
#include "PPgGeneral.h"
#include "PPgConnection.h"
#include "PPgServer.h"
#include "PPgDirectories.h"
#include "PPgFiles.h"
#include "PPgStats.h"
#include "PPgNotify.h"
#include "Preferences.h"
#include "PPgTweaks.h"
#include "PPgDisplay.h"
#include "PPgSecurity.h"
#include "PPgWebServer.h"
#include "PPgScheduler.h"
#include "PPgMessages.h"
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
#include "PPgDebug.h"
#endif
#include "otherfunctions.h"
#include "TreePropSheet.h"
//==> PPgTabControl [shadow2004]
#include ".\NextEMF\PPG\PPgDisplay2.h"		//PPGDisplay2		Extended
#include ".\NextEMF\PPG\PPgConnection2.h"	//PPGConnection2	Hardlimit
#include ".\NextEMF\PPG\PPgConnection3.h"	//PPGConnection2	V-Limits
#include ".\NextEMF\PPG\PPgFiles2.h"		//PPGFiles2		Drop
#include ".\NextEMF\PPG\PPgSecurity2.h"		//PPGSecurity2		IPFilter
//<== PPgTabControl [shadow2004]
#include "NextEMF/Slidebar/SlideBar.h"			//>>> WiZaRd::SlideBar [eMule+]

//>>> WiZaRd::SlideBar [eMule+]
#define IDC_PREFS_SLIDEBAR	111	//note: this *should* be unique!
#define PREF_PARENT_CLASS	CPropertySheet
//#define PREF_PARENT_CLASS	CTreePropSheet
//<<< WiZaRd::SlideBar [eMule+]

//==> PPgTabControl [shadow2004]
enum enumPrefencesItems
{
	// Category: basic options
	PW_GENERAL = 0,	
	PW_DISPLAY,
	PW_CONNECTION,
	PW_SERVER,
	PW_DIRECTORY,
	PW_FILES,

	// Category: advanced options
	PW_NOTIFY,
	PW_STATISTIC,
	PW_MESSAGES,
	PW_SECURITY,
	PW_SCHEDULER,
	PW_WEB,
	PW_TWEAKS,

	// no Category, tabbed pages
	PW_DISPLAY2,
	PW_CONNECTION2,
	PW_CONNECTION3,
	PW_FILES2,
	PW_SECURITY2,
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	PW_DEBUG,
#endif
};

#define LastPage PW_DEBUG
//<== PPgTabControl [shadow2004]

class CPreferencesDlg : public PREF_PARENT_CLASS
{
	DECLARE_DYNAMIC(CPreferencesDlg)

public:
	CPreferencesDlg();
	virtual ~CPreferencesDlg();
	
	CPPgGeneral		m_wndGeneral;
	CPPgConnection	m_wndConnection;
	CPPgServer		m_wndServer;
	CPPgDirectories	m_wndDirectories;
	CPPgFiles		m_wndFiles;
	CPPgStats		m_wndStats;
	CPPgNotify		m_wndNotify;
	CPPgTweaks		m_wndTweaks;
	CPPgDisplay		m_wndDisplay;
	CPPgSecurity	m_wndSecurity;
	CPPgWebServer	m_wndWebServer;
	CPPgScheduler	m_wndScheduler;
	CPPgMessages	m_wndMessages;
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	CPPgDebug		m_wndDebug;
#endif
//==> PPgTabControl [shadow2004]
	CPPgDisplay2		m_wndDisplay2;			// Extended
	CPPgConnection2		m_wndConnection2;		// Hardlimit
	CPPgConnection3		m_wndConnection3;		// V Limit
	CPPgFiles2		m_wndFiles2;			// Drop
	CPPgSecurity2		m_wndSecurity2;			// IPFilter
//<== PPgTabControl [shadow2004]

//>>> WiZaRd::SlideBar [eMule+]
	CImageList		m_ImageList;
	CSlideBar		m_SlideBar;
//<<< WiZaRd::SlideBar [eMule+]

//==> PPgTabControl [shadow2004]
	void Localize();
	void SetStartPage(UINT uStartPageID);
//<== PPgTabControl [shadow2004]

//==> PPgTabControl [shadow2004]
	void SwitchTab(int page);
	int	StartPageDisplay;	
	int	StartPageConnection;	
	int	StartPageFiles;	
	int	StartPageSecurity;	
//<== PPgTabControl [shadow2004]

//==> PPgTabControl [shadow2004]
protected:
	INT m_nActiveWnd;
//<== PPgTabControl [shadow2004]
	bool m_bSaveIniFile;

	virtual BOOL OnInitDialog();

	DECLARE_MESSAGE_MAP()
	afx_msg void OnDestroy();
	afx_msg LRESULT	OnSlideBarSelChanged(WPARAM wParam, LPARAM lParam); //>>> WiZaRd::SlideBar [eMule+]

};
